import 'dart:html';
import 'dart:async';

import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/components/util_widgets.dart';

class UserSearchInput extends StatefulWidget {
  final NavigatorRouteChanger routeChanger;

  const UserSearchInput({
    Key? key,
    required this.routeChanger,
  }) : super(key: key);

  @override
  _UserSearchInputState createState() => _UserSearchInputState();
}

class _UserSearchInputState extends State<UserSearchInput> with AppActiveContentMixin {
  final _inputId = 'input-user-search';

  InputElement get input => document.getElementById(_inputId) as InputElement;

  // search related
  late Timer _searchTriggerTimer;

  @override
  void onLoadEvent() {
    _searchTriggerTimer = Timer(Duration.zero, _search);
  }

  @override
  void onDisposeEvent() => _disposeSearchRequest();

  @override
  build(context) {
    return Division(
      className: 'sidebar-menu',
      child: Division(
        className: 'sidebar-content',
        children: [
          Form(
            onSubmit: ((event) => {event.preventDefault(), _search()}),
            className: 'form-inline',
            children: [
              InputText(
                id: _inputId,
                className: 'form-control search',
                placeholder: 'Search User',
                onChange: _onChange,
              ),
              if (_searchTriggerTimer.isActive) UtilWidgets.smallPreloader(),
            ],
          ),
        ],
      ),
    );
  }

  void _onChange(EmittedEvent event) => _search();

  Future<void> _search() async {
    _disposeSearchRequest();

    if (input.value!.isEmpty) {
      setState(() {});

      return;
    }

    setState(() {
      _searchTriggerTimer = Timer(const Duration(seconds: 2), () => _performSearchRequest());
    });
  }

  void _performSearchRequest() {
    if (input.value!.isEmpty) return;

    widget.routeChanger('search', {'': input.value!});

    setState(() {});
  }

  void _disposeSearchRequest() {
    if (_searchTriggerTimer.isActive) {
      _searchTriggerTimer.cancel();
    }
  }
}
